/*
 * Decompiled with CFR 0.152.
 */
package org.pokesplash.gts.history;

import java.text.DecimalFormat;
import java.util.Date;
import java.util.UUID;
import net.minecraft.class_5250;
import org.pokesplash.gts.api.provider.HistoryAPI;
import org.pokesplash.gts.util.Utils;

public abstract class HistoryItem<T> {
    private String version = "2.0";
    private boolean isPokemon;
    private UUID id;
    private UUID sellerUuid;
    private String sellerName;
    private double price;
    private long soldDate;
    private String buyerName;

    public HistoryItem(boolean isPokemon, UUID sellerUuid, String sellerName, double price, String buyerName) {
        this.isPokemon = isPokemon;
        this.id = UUID.randomUUID();
        this.sellerUuid = sellerUuid;
        this.sellerName = sellerName;
        this.price = price;
        this.soldDate = new Date().getTime();
        this.buyerName = buyerName;
    }

    public boolean isPokemon() {
        return this.isPokemon;
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getSellerUuid() {
        return this.sellerUuid;
    }

    public String getSellerName() {
        return this.sellerName;
    }

    public double getPrice() {
        return this.price;
    }

    public String getPriceAsString() {
        DecimalFormat df = new DecimalFormat("0.##");
        return df.format(this.price);
    }

    public long getSoldDate() {
        return this.soldDate;
    }

    public String getBuyerName() {
        return this.buyerName;
    }

    public abstract T getListing();

    public String getVersion() {
        return this.version;
    }

    public abstract boolean isHistoryItemValid();

    public void write() {
        if (HistoryAPI.getHighestPriority() != null) {
            HistoryAPI.getHighestPriority().write(this);
        }
        Utils.writeFileAsync("/config/gts/history/" + String.valueOf(this.sellerUuid) + "/", String.valueOf(this.id) + ".json", Utils.newGson().toJson((Object)this));
    }

    public abstract class_5250 getDisplayName();
}

